/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.host;

import ags.controller.Configurator;
import ags.controller.FileType;
import ags.ui.host.StringComponent;
import ags.ui.host.Style;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;

class FileComponent
extends JPanel
implements ActionListener {
    Field backingField;
    private int TEXT_FIELD_WIDTH = 150;
    private String extensionFilter;
    private String fileTypeName;
    private int fileSelectionMode = 0;
    private JButton browseButton;
    private JTextField textField;

    public void actionPerformed(ActionEvent e) {
        Configurator.setVariable(this.backingField, this.textField.getText());
        System.out.println(this.backingField.getName() + " -> " + this.textField.getText());
    }

    public void synchronizeValue() {
        try {
            Object value = this.backingField.get(null);
            if (value == null) {
                this.setText("");
            } else {
                this.setText(String.valueOf(value));
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(StringComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(StringComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public FileComponent(Field f) {
        this.backingField = f;
        FileType type = f.getAnnotation(FileType.class);
        if (".".equals(type.value())) {
            this.fileSelectionMode = 1;
        } else {
            this.setFileTypeName(type.value());
            this.setExtensionFilter(type.value());
        }
        this.initComponents();
        this.textField.addActionListener(this);
        this.synchronizeValue();
    }

    private void initComponents() {
        this.textField = new JTextField();
        this.browseButton = new JButton();
        this.browseButton.setText("...");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileComponent.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.textField, -1, this.TEXT_FIELD_WIDTH, Short.MAX_VALUE).addPreferredGap(0).add(this.browseButton)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createParallelGroup(3).add(this.textField, -2, -1, -2).add(this.browseButton)));
        Style.apply(this.textField);
        Style.apply(this.browseButton);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File currentDirectory = new File(".");
        JFileChooser chooser = new JFileChooser();
        Style.apply(chooser);
        chooser.setFileSelectionMode(this.fileSelectionMode);
        if (this.extensionFilter != null && this.fileTypeName != null) {
            FileFilter filter = new FileFilter(){
                String[] extensions;
                {
                    this.extensions = FileComponent.this.extensionFilter.toLowerCase().split(",");
                }

                public boolean accept(File f) {
                    for (int i = 0; i < this.extensions.length; ++i) {
                        if (!f.getPath().toLowerCase().endsWith(this.extensions[i])) continue;
                        return true;
                    }
                    return false;
                }

                public String getDescription() {
                    return FileComponent.this.fileTypeName;
                }
            };
            chooser.setFileFilter(filter);
        }
        try {
            File f = new File(this.textField.getText());
            if (f.exists()) {
                if (f.isDirectory()) {
                    chooser.setCurrentDirectory(f);
                } else {
                    chooser.setCurrentDirectory(f.getParentFile());
                    chooser.setSelectedFile(f);
                }
            } else {
                chooser.setCurrentDirectory(currentDirectory);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File selectedFile = chooser.getSelectedFile();
                if (selectedFile.getCanonicalPath().startsWith(currentDirectory.getCanonicalPath())) {
                    String use = selectedFile.getCanonicalPath().substring(currentDirectory.getCanonicalPath().length() + 1);
                    this.textField.setText(use);
                } else {
                    this.textField.setText(selectedFile.getPath());
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FileComponent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getExtensionFilter() {
        return this.extensionFilter;
    }

    public void setExtensionFilter(String extensionFilter) {
        this.extensionFilter = extensionFilter;
    }

    public String getFileTypeName() {
        return this.fileTypeName;
    }

    public void setFileTypeName(String fileTypeName) {
        this.fileTypeName = fileTypeName;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }
}

